<?php
/****
 * vB Optimise
 * Copyright 2008; Deceptor
 * All Rights Reserved
 * Code may not be copied, in whole or part without written permission
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

if (!is_object($vbulletin))
{
	die('Cannot access directly.');
}

class vb_activecache_memcache extends vb_activecache
{
	static $class = __CLASS__;
	static $instance;
	var $memcache;

	function get_instance()
	{
		return (self::$instance) ? self::$instance : (self::$instance =& new self::$class());
	}

	function suicide()
	{
		if (self::$instance)
		{
			self::$instance = null;
		}

		parent::suicide();
	}

	function connect()
	{
		global $vbulletin;

		if (!class_exists('Memcache'))
		{
			return false;
		}

		$this->memcache = new Memcache;

		if (is_array($vbulletin->config['Misc']['memcacheserver']))
		{
			foreach (array_keys($vbulletin->config['Misc']['memcacheserver']) AS $key)
			{
				$this->memcache->addServer(
					$vbulletin->config['Misc']['memcacheserver'][$key],
					$vbulletin->config['Misc']['memcacheport'][$key],
					$vbulletin->config['Misc']['memcachepersistent'][$key],
					$vbulletin->config['Misc']['memcacheweight'][$key],
					$vbulletin->config['Misc']['memcachetimeout'][$key],
					$vbulletin->config['Misc']['memcacheretry_interval'][$key]
				);
			}
		}
		else
		{
			$this->memcache->addServer($vbulletin->config['Misc']['memcacheserver'], $vbulletin->config['Misc']['memcacheport']);
		}

		return true;
	}

	function set_title(&$title)
	{
		$title = $this->prefix . $title;
	}

	function fetch($title)
	{
		if (!$this->memcache && !$this->connect())
		{
			return false;
		}

		$this->set_title($title);

		if ((($item = $this->memcache->get($title)) === false))
		{
			return false;
		}

		return isset($item) ? $this->integrity_check(unserialize($item)) : false;
	}

	function set($title, $item)
	{
		if (!$this->memcache && !$this->connect())
		{
			return false;
		}

		$this->set_title($title);

		if (trim($item) == '')
		{
			$item = '{_______VB_ACTIVE_CACHE_BLANK_______}';
		}

		$this->memcache->set($title, serialize($item), MEMCACHE_COMPRESSED);
	}

	function flush()
	{
		if (!$this->memcache && !$this->connect())
		{
			return false;
		}

		$this->memcache->flush();
	}
}

class vb_activecache_xcache extends vb_activecache
{
	static $class = __CLASS__;
	static $instance;

	function get_instance()
	{
		return (self::$instance) ? self::$instance : (self::$instance =& new self::$class());
	}

	function suicide()
	{
		if (self::$instance)
		{
			self::$instance = null;
		}

		parent::suicide();
	}

	function connect()
	{
		if (!function_exists('xcache_get'))
		{
			return false;
		}

		return true;
	}

	function set_title(&$title)
	{
		$title = $this->prefix . $title;
	}

	function fetch($title)
	{
		if (!$this->connect())
		{
			return false;
		}

		$this->set_title($title);

		if (!xcache_isset($title))
		{
			return false;
		}

		return $this->integrity_check(xcache_get($title));
	}

	function set($title, $item)
	{
		if (!$this->connect())
		{
			return false;
		}

		$this->set_title($title);

		if (trim($item) == '')
		{
			$item = '{_______VB_ACTIVE_CACHE_BLANK_______}';
		}

		xcache_set($title, $item);
	}

	function authenticate()
	{
		header('WWW-Authenticate: Basic realm="XCache Administration Login Required"');
		print_cp_message('vB Optimise: Your XCache requires administration authentification to be able to clear to cache, to login simply try flush the cache again. To disable admin authentification for XCache set "enable_auth" to Off in your php.ini configuration.<pre>xcache.admin.enable_auth = Off</pre>');
	}

	function flush($silent = false)
	{
		global $vbulletin;

		if ($vbulletin->options['_vboptimise_xcache_pw'] && $silent)
		{
			return false; // XCache will hault operations otherwise
		}

		if ($vbulletin->options['_vboptimise_xcache_pw'] && !$silent)
		{
			$this->authenticate();
		}

		$any = false;
		for ($x = 0, $total = @xcache_count(XC_TYPE_VAR); $x < $total; $x++)
		{
			if (@xcache_clear_cache(XC_TYPE_VAR, $x))
			{
				$any = true;
			}
		}

		if (!$any && !isset($_SERVER['PHP_AUTH_USER']) && $x < 1 && !$silent)
		{
			$this->authenticate();
		}
	}
}

class vb_activecache_apc extends vb_activecache
{
	static $class = __CLASS__;
	static $instance;

	function get_instance()
	{
		return (self::$instance) ? self::$instance : (self::$instance =& new self::$class());
	}

	function suicide()
	{
		if (self::$instance)
		{
			self::$instance = null;
		}

		parent::suicide();
	}

	function connect()
	{
		if (!function_exists('apc_fetch'))
		{
			return false;
		}

		return true;
	}

	function set_title(&$title)
	{
		$title = $this->prefix . $title;
	}

	function fetch($title)
	{
		if (!$this->connect())
		{
			return false;
		}

		$this->set_title($title);

		return $this->integrity_check(apc_fetch($title));
	}

	function set($title, $item)
	{
		if (!$this->connect())
		{
			return false;
		}

		$this->set_title($title);

		if (trim($item) == '')
		{
			$item = '{_______VB_ACTIVE_CACHE_BLANK_______}';
		}

		apc_store($title, $item);
	}

	function flush()
	{
		apc_clear_cache();
	}
}

class vb_activecache_eaccelerator extends vb_activecache
{
	static $class = __CLASS__;
	static $instance;

	function get_instance()
	{
		return (self::$instance) ? self::$instance : (self::$instance =& new self::$class());
	}

	function suicide()
	{
		if (self::$instance)
		{
			self::$instance = null;
		}

		parent::suicide();
	}

	function connect()
	{
		if (!function_exists('eaccelerator_get'))
		{
			return false;
		}

		return true;
	}

	function set_title(&$title)
	{
		$title = $this->prefix . $title;
	}

	function fetch($title)
	{
		if (!$this->connect())
		{
			return false;
		}

		$this->set_title($title);

		return $this->integrity_check(eaccelerator_get($title));
	}

	function set($title, $item)
	{
		if (!$this->connect())
		{
			return false;
		}

		$this->set_title($title);

		if (trim($item) == '')
		{
			$item = '{_______VB_ACTIVE_CACHE_BLANK_______}';
		}

		eaccelerator_rm($title);
		eaccelerator_put($title, $item);
	}

	function flush($silent = false)
	{
		$success = '__vBOptimise_EA_Test_' . rand(3,999) . '__';

		$this->set('vBOptimiseTest', $success);

		@eaccelerator_clear();

		if ($this->fetch('vBOptimiseTest') == $success)
		{
			print_cp_message('vB Optimise: Your eAccelerator requires you to specify permission to this directory to allow vB Optimise to clear your cache. For more information please visit <a href="http://bart.eaccelerator.net/doc/phpdoc/eAccelerator/_info_php.html#functioneaccelerator_clear" target="_blank"></a>.');
		}
	}
}

class vb_activecache_filecache extends vb_activecache
{
	static $class = __CLASS__;
	static $instance;

	function get_instance()
	{
		return (self::$instance) ? self::$instance : (self::$instance =& new self::$class());
	}

	function suicide()
	{
		if (self::$instance)
		{
			self::$instance = null;
		}

		parent::suicide();
	}

	function set_title(&$title)
	{
		$title = md5($this->prefix . $title);
	}

	function fetch($title)
	{
		$this->set_title($title);

		$file = DIR . '/vboptimise/' . $title . '.php';

		if (!file_exists($file))
		{
			return false;
		}

		$handle = @fopen($file, 'r');
		$item = trim(str_replace('<'.'?php exit; ?'.'>', '', @fread($handle, @filesize($file))));
		@fclose($handle);

		return $this->integrity_check(unserialize($item));
	}

	function set($title, $item)
	{
		global $vbulletin;

		$this->set_title($title);

		if (trim($item) == '')
		{
			$item = '{_______VB_ACTIVE_CACHE_BLANK_______}';
		}

		$file = DIR . '/vboptimise/' . $title . '.php';
		$item = "<"."?"."php exit; ?".">\r\n" . serialize($item);

		if ($handle = @fopen($file, 'wb'))

		{

			@fputs($handle, $item, ((strlen($item) > 0)? strlen($item) : 1));

			@fclose($handle);

			@chmod($file, $vbulletin->options['_vboptimise_suphp'] ? 0644 : 0777);

		}
	}

	function flush()
	{
		$directory = DIR . '/vboptimise';

		if (is_dir($directory))

		{

			$handle = opendir($directory);



			while (($filename = readdir($handle)) !== false)

			{

				if (preg_match("#\.php$#i", $filename) && !is_dir($directory . '/' . $filename))

				{

					@unlink($directory . '/' . $filename);

				}

			}



			closedir($handle);

		}
	}
}
?>